#include <avr/io.h>
#include <util/delay_basic.h>

#define MINIMUM_DELAY 10
#define DISCHARGE_MULTIPLIER 25

void init() {
	// PB0 output on for PWM output, PB2 digital input off for ADC
	DDRB = _BV(PB0);
	DIDR0 = _BV(ADC1D);

	// ADC free-running with a /64 prescale, Vcc reference, ADC1 (PB2) input, right (low-bit) aligned
	ADCSRB = 0;
	ADMUX = _BV(MUX0);
	ADCSRA = _BV(ADEN) | _BV(ADATE) | _BV(ADPS2) | _BV(ADPS1);
	ADCSRA |= _BV(ADSC);
}

int main() {
	unsigned short adcValue;

	init();

	while(1) {
		
		adcValue = ADC;
		if(adcValue < MINIMUM_DELAY) adcValue = MINIMUM_DELAY;

		PORTB |= _BV(PB0);
		_delay_loop_2(adcValue);
		PORTB &= ~_BV(PB0);
		_delay_loop_2(adcValue * DISCHARGE_MULTIPLIER);
	}

	return 0;  // unreached
}
