/*
 * codes.h:	Foxtel box IR control codes
 *
 *	By:	Alan Yates <alany@ay.com.au>
 */

struct code_t {
        char *name;
        char *code;
};

struct code_t foxtel_codes[] = {
	{"pwr",		"x100010000"},
	{"0",		"x100000000"},
	{"1",		"x100000001"},
	{"2",		"x100000010"},
	{"3",		"x100000011"},
	{"4",		"x100000100"},
	{"5",		"x100000101"},
	{"6",		"x100000110"},
	{"7",		"x100000111"},
	{"8",		"x100001000"},
	{"9",		"x100001001"},
	{"up",		"x100011010"},
	{"rcl",		"x100011010"},
	{"f",		"x100011001"},
	{"-",		"x100010110"},
	{"left",	"x100010110"},
	{"menu",	"x100010111"},
	{"+",		"x100010001"},
	{"right",	"x100010001"},
	{"i",		"x100011111"},
	{"down",	"x100001011"},
	{"fav",		"x100001011"},
	{"store",	"x100010011"},
	{"norm",	"x100010101"},
	{"mute",	"x100011110"},
	{0, 		0}
};

/* foxtel protocol definitions */
#define foxtel_ir_t 21		/* IR carrier period */
#define foxtel_bit_t 600	/* IR TX time */
#define foxtel_one_t 7000	/* delay that codes '1' */
#define foxtel_zero_t 4400	/* delay that codes '0' */
#define foxtel_sync_t 3200	/* sync pulse spacing */
#define foxtel_tailspace 1	/* last 'space' time given to kernel */
