/* basic operations */
enum {
	NOP	= 0,

	ASSIGN	= 0x1,
	TOGGLE	= 0x2,

	RAMP	= 0x5,
	FADE	= 0x6,

	WAIT	= 0xA,
	RATE	= 0xB,
	SPEED	= 0xC,

	BEGIN	= 0xD,
	END	= 0xE,
	RESET	= 0xF
};

/* nibble packed instructions */
enum {
	FOR		= 0x0D,
	NEXT		= 0x0E,
	DO		= 0x1D,
	WHILE		= 0x1E,	

	ASSIGN_0000	= 0x01,
	ASSIGN_0001	= 0x11,
	ASSIGN_0010	= 0x21,
	ASSIGN_0011	= 0x31,
	ASSIGN_0100	= 0x41,
	ASSIGN_0101	= 0x51,
	ASSIGN_0110	= 0x61,
	ASSIGN_0111	= 0x71,
	ASSIGN_1000	= 0x81,
	ASSIGN_1001	= 0x91,
	ASSIGN_1010	= 0xa1,
	ASSIGN_1011	= 0xb1,
	ASSIGN_1100	= 0xc1,
	ASSIGN_1101	= 0xd1,
	ASSIGN_1110	= 0xe1,
	ASSIGN_1111	= 0xf1,

	TOGGLE_0000	= 0x02,
	TOGGLE_0001	= 0x12,
	TOGGLE_0010	= 0x22,
	TOGGLE_0011	= 0x32,
	TOGGLE_0100	= 0x42,
	TOGGLE_0101	= 0x52,
	TOGGLE_0110	= 0x62,
	TOGGLE_0111	= 0x72,
	TOGGLE_1000	= 0x82,
	TOGGLE_1001	= 0x92,
	TOGGLE_1010	= 0xa2,
	TOGGLE_1011	= 0xb2,
	TOGGLE_1100	= 0xc2,
	TOGGLE_1101	= 0xd2,
	TOGGLE_1110	= 0xe2,
	TOGGLE_1111	= 0xf2,

	RAMP_0000	= 0x05,
	RAMP_0001	= 0x15,
	RAMP_0010	= 0x25,
	RAMP_0011	= 0x35,
	RAMP_0100	= 0x45,
	RAMP_0101	= 0x55,
	RAMP_0110	= 0x65,
	RAMP_0111	= 0x75,
	RAMP_1000	= 0x85,
	RAMP_1001	= 0x95,
	RAMP_1010	= 0xa5,
	RAMP_1011	= 0xb5,
	RAMP_1100	= 0xc5,
	RAMP_1101	= 0xd5,
	RAMP_1110	= 0xe5,
	RAMP_1111	= 0xf5,

	FADE_0000	= 0x06,
	FADE_0001	= 0x16,
	FADE_0010	= 0x26,
	FADE_0011	= 0x36,
	FADE_0100	= 0x46,
	FADE_0101	= 0x56,
	FADE_0110	= 0x66,
	FADE_0111	= 0x76,
	FADE_1000	= 0x86,
	FADE_1001	= 0x96,
	FADE_1010	= 0xa6,
	FADE_1011	= 0xb6,
	FADE_1100	= 0xc6,
	FADE_1101	= 0xd6,
	FADE_1110	= 0xe6,
	FADE_1111	= 0xf6
	
};
