unsigned char program[] PROGMEM = {
	// start with everything off
	ASSIGN_0000,
	
	// fade all on and off
	SPEED, 1,
	RATE, 32,
	FOR, 5,
		RAMP_1111,
		WAIT,
		FADE_1111,
		WAIT,
	NEXT,

	// fade just the border
	FOR, 10,
		RAMP_0011,
		WAIT,
		FADE_0011,
		WAIT,
	NEXT,

	// fade the border, toggle the middle
	FOR, 10,
		RAMP_0011,
		WAIT,
		FADE_0011,
		WAIT,
		TOGGLE_1100,
	NEXT,

	// fade the border, toggle the middle, alternating
	ASSIGN_0100,
	FOR, 10,
		RAMP_0011,
		WAIT,
		FADE_0011,
		WAIT,
		TOGGLE_1100,
	NEXT,


	// alternating fade the border, alternating toggle the middle
	SPEED, 8,
	ASSIGN_0100,
	FOR, 10,
		TOGGLE_1100,
		NOP,
		FADE_0010,
		RAMP_0001,
		WAIT,
		TOGGLE_1100,
		NOP,
		FADE_0001,
		RAMP_0010,
		WAIT,
	NEXT,

	// alternating toggle the border, alternating fade the middle
	ASSIGN_0010,
	FOR, 10,
		TOGGLE_0011,
		NOP,
		FADE_1000,
		RAMP_0100,
		WAIT,
		TOGGLE_0011,
		NOP,
		FADE_0100,
		RAMP_1000,
		WAIT,
	NEXT,


	// alternating toggle the border, alternating rapid fade the middle
	RATE, 32,
	SPEED, 1,
	ASSIGN_0010,
	FOR, 10,
		TOGGLE_0011,
		FOR, 4,
			FADE_1000,
			RAMP_0100,
			WAIT,
			FADE_0100,
			RAMP_1000,
			WAIT,
		NEXT,
	NEXT,
/*
*/

	// toggle border while alternating fade the middle
	SPEED, 4,
	RATE, 16,
	ASSIGN_1010,
	FOR, 10,
		FADE_1000,
		RAMP_0100,
		DO,
			TOGGLE_0011,
			NOP,
		WHILE,
		FADE_0100,
		RAMP_1000,
		DO,
			TOGGLE_0011,
			NOP,
		WHILE,
	NEXT,
};
